package org.jeecg.modules.dynamicStaticAnalysis.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.constant.DictConstant;
import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigGradeLimit;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.ConfigGradeLimitMapper;
import org.jeecg.modules.dynamicStaticAnalysis.service.IConfigGradeLimitService;
import org.jeecg.modules.dynamicStaticAnalysis.util.StrUtil;
import org.jeecg.modules.system.entity.SysDict;
import org.jeecg.modules.system.entity.SysDictItem;
import org.jeecg.modules.system.mapper.SysDictItemMapper;
import org.jeecg.modules.system.mapper.SysDictMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * <p>
 * 动静态分析-配置-单元化管理阈值 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-08-01
 */
@Service
public class ConfigGradeLimitServiceImpl extends ServiceImpl<ConfigGradeLimitMapper, ConfigGradeLimit> implements IConfigGradeLimitService {


    @Resource
    private SysDictMapper sysDictMapper;
    @Resource
    private SysDictItemMapper sysDictItemMapper;

    @Override
    public List<ConfigGradeLimit> listRecord() {
        List<ConfigGradeLimit> records = this.lambdaQuery().eq(ConfigGradeLimit::getDelFlag, "0").list();
        if (ObjectUtil.isEmpty(records)) {
            records = this.initConfigGradeLimit();
        }

        return records;
    }

    /**
     * 初始化参数
     *
     * @return
     */
    private List<ConfigGradeLimit> initConfigGradeLimit() {
        List<ConfigGradeLimit> result = new ArrayList<>(64);

        // 1.动态查找速度等级
        // 字典
        LambdaQueryWrapper<SysDict> sysDictWrapper = Wrappers.lambdaQuery();
        sysDictWrapper.eq(SysDict::getDictCode, DictConstant.EQUIPMENT_SPEED_OPTS).last("limit 1");
        SysDict sysDict = sysDictMapper.selectOne(sysDictWrapper);
        // 字典项目
        LambdaQueryWrapper<SysDictItem> sysDictItemWrapper = Wrappers.lambdaQuery();
        sysDictItemWrapper.eq(SysDictItem::getDictId, sysDict.getId());
        List<SysDictItem> sysDictItems = sysDictItemMapper.selectList(sysDictItemWrapper);


        // 2.循环生成
        // 1-钢轨 2-道岔 3-曲线 4-竖曲线
        List<Integer> deviceTypeList = IntStream.range(1, 5).boxed().collect(Collectors.toList());
        for (Integer deviceType : deviceTypeList) {
            for (SysDictItem sysDictItem : sysDictItems) {
                Integer[] speedLevels = StrUtil.getSpeedLevel(sysDictItem.getItemText());

                // 优良
                ConfigGradeLimit a = new ConfigGradeLimit();
                a.setId(UUIDGenerator.generate());
                a.setDictLabel(sysDictItem.getItemText());
                a.setDictValue(sysDictItem.getItemValue());
                a.setSpeedMin(speedLevels[0]);
                a.setSpeedMax(speedLevels[1]);
                a.setDeviceType(deviceType);
                a.setGradeLevel(1); //1-优良
                a.setGradeLevelStr("优良");
                a.setGradeMin(new BigDecimal("0"));
                a.setGradeMax(new BigDecimal("15"));
                result.add(a);

                // 合格
                ConfigGradeLimit b = new ConfigGradeLimit();
                b.setId(UUIDGenerator.generate());
                b.setDictLabel(sysDictItem.getItemText());
                b.setDictValue(sysDictItem.getItemValue());
                b.setSpeedMin(speedLevels[0]);
                b.setSpeedMax(speedLevels[1]);
                b.setDeviceType(deviceType);
                b.setGradeLevel(2); //2-合格
                b.setGradeLevelStr("合格");
                b.setGradeMin(new BigDecimal("15"));
                b.setGradeMax(new BigDecimal("20"));
                result.add(b);

                // 失格
                ConfigGradeLimit c = new ConfigGradeLimit();
                c.setId(UUIDGenerator.generate());
                c.setDictLabel(sysDictItem.getItemText());
                c.setDictValue(sysDictItem.getItemValue());
                c.setSpeedMin(speedLevels[0]);
                c.setSpeedMax(speedLevels[1]);
                c.setDeviceType(deviceType);
                c.setGradeLevel(3); //3-失格
                c.setGradeLevelStr("失格");
                c.setGradeMin(new BigDecimal("20"));
                c.setGradeMax(new BigDecimal("99999"));
                result.add(c);
            }

        }

        this.saveBatch(result);

        return result;
    }
}
