package org.jeecg.modules.dynamicStaticAnalysis.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 动静态分析-分析批次-单元设备
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
@Data
@ApiModel(value = "AnalysisBatchUnitDeviceVO对象", description = "动静态分析-分析批次-单元设备")
public class AnalysisBatchUnitDeviceVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("单元设备id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨 2-曲线 3-竖曲线 4-道岔")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartingMileage;

    @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("单元得分等级中文")
    private String unitScoreLevelStr;

    @ApiModelProperty("单元得分等级 1-优良 2-合格 3-失格")
    private int unitScoreLevel;

    @ApiModelProperty("单元得分")
    private String unitScore;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("超限list")
    private List<AnalysisBatchUnitDeviceTransfiniteVO> transfiniteList;

    @ApiModelProperty("是否超限 0-否 1-是")
    private Integer isTransfinite;

    @ApiModelProperty("是否派工 0-否 1-是")
    private Integer isWork;

    @ApiModelProperty("派工状态 0-未派工 1-派工")
    private Integer workStatus;
}
