package org.jeecg.modules.maintenanceWork.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 维修作业---道床检查
 * </p>
 *
 * @author hkl
 * @since 2024-08-05
 */
@Getter
@Setter
@ApiModel(value = "WorkBatchDetailTrackBedInfo对象", description = "维修作业---道床检查")

public class WorkBatchDetailTrackBedInfoDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check）")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    private String deviceId;

    @ApiModelProperty("维修作业主表id")
    private String workId;

    @ApiModelProperty("维修作业单元表id")
    private String workDetailId;

    @ApiModelProperty("道床id")
    private String trackBedId;

    @ApiModelProperty("道床编号")
    private String trackBedCode;

    @ApiModelProperty("道床类型")
    private String trackBedType;

    @ApiModelProperty("道床起点里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("道床终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("道床长度")
    private BigDecimal trackBedLen;

    @ApiModelProperty("检查项目名称")
    private String ekProjectName;

    @ApiModelProperty("检查项目内容")
    private String ekProjectContent;

    @ApiModelProperty("检查合格评判标准")
    private String ekProjectTemplate;

    @ApiModelProperty("现场检查项目状态（1：合格；2：良好；3：不合格）")
    private String ekProjectStatus;

    @ApiModelProperty("整改说明")
    private String reformRemark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;


}
