package org.jeecg.modules.maintenanceWork.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 维修作业管理-作业计划批次管理表
 * </p>
 *
 * @author hkl
 * @since 2023-08-09
 */
@Data
@ApiModel(value = "WorkBatchSaveOrUpdateDTO对象", description = "维修作业管理-页面来源保存或更新dto")
public class WorkBatchSaveOrUpdateDTO {

    private static final long serialVersionUID = 1L;

    private String id;

    @ApiModelProperty("作业计划批次号")
    private String workBatchCode;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty("作业起始里程")
    private BigDecimal workStartMileage;

    @ApiModelProperty("作业终点里程")
    private BigDecimal workEndMileage;

    @ApiModelProperty("作业终止时间")
    private Date workStartTime;

    @ApiModelProperty("作业终止时间")
    private Date workEndTime;

    @ApiModelProperty("作业班组")
    private String team;

    @ApiModelProperty("分析类型（0-动静态分析 1-道岔检查 2-钢轨常规探伤检查 3-曲线钢轨磨耗检查 4-钢轨波磨检查 5-道床检查 6-线路检查）")
    private Integer analysisType;

    @ApiModelProperty("作业类型（1-单元方式 2-分析批次方式）")
    private Integer workType;

    @ApiModelProperty("来源 1-页面添加 2-超限派工添加")
    private Integer source;

    @ApiModelProperty("作业状态 0-未作业 1-已作业")
    private Integer workStatus;

    @ApiModelProperty("详情列表")
    private List<WorkBatchSaveOrUpdateDetailDTO> detailList;
}
