package org.jeecg.modules.maintenanceWork.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态几何尺寸对应得里程相关信息详情表
 * </p>
 *
 * @author hkl
 * @since 2023-09-14
 */
@Getter
@Setter
@TableName("t_mw_work_batch_detail_modify")
@ApiModel(value = "WorkBatchDetailModify对象", description = "动静态几何尺寸对应得里程相关信息详情表")
public class WorkBatchDetailModify implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("作业计划批次id")
    @TableField("work_batch_id")
    private String workBatchId;

    @ApiModelProperty("作业计划批次code")
    @TableField("work_batch_code")
    private String workBatchCode;

    @ApiModelProperty("作业计划详情id")
    @TableField("work_batch_detail_id")
    private String workBatchDetailId;

    @ApiModelProperty("单元设备id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    @TableField("unit_device_code")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    @TableField("unit_start_mileage")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("设备单元中心里程")
    @TableField("unit_center_mileage")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    @TableField("unit_end_mileage")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("测点")
    @TableField("measure_point")
    private Integer measurePoint;

    @ApiModelProperty("轨距")
    @TableField("track_gauge")
    private String trackGauge;

    @ApiModelProperty("水平")
    @TableField("level")
    private String level;

    @ApiModelProperty("三角坑")
    @TableField("triangular_pit")
    private String triangularPit;

    @ApiModelProperty("方向")
    @TableField("direction")
    private String direction;

    @ApiModelProperty("高低")
    @TableField("height")
    private String height;

    @ApiModelProperty("结构")
    @TableField("structure")
    private String structure;

    @ApiModelProperty("整改")
    @TableField("rectification")
    private String rectification;


}
