package org.jeecg.modules.maintenanceWork.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 维修作业---钢轨探伤检查
 * </p>
 *
 * @author hkl
 * @since 2024-08-05
 */
@Getter
@Setter
@ApiModel(value = "WorkBatchDetailRailWearInfo对象", description = "维修作业---钢轨探伤检查")

public class WorkBatchDetailRailWearInfoVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check）")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    private String deviceId;

    @ApiModelProperty("维修作业主表id")
    private String workId;

    @ApiModelProperty("维修作业单元表id")
    private String workDetailId;

    @ApiModelProperty("检查设备id(设备资产四种表的主键)")
    private String deviceProjectId;

    @ApiModelProperty("检查设备编码(设备资产四种表的unit_code)")
    private String deviceProjectCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    private Integer deviceProjectType;

    @ApiModelProperty("股别(1-左股，2-右股)")
    private Integer damageLevel;

    @ApiModelProperty("伤损钢轨数量")
    private Integer damageNum;

    @ApiModelProperty("伤损种类（1-鱼鳞纹,2-剥落掉块,3-表面疲劳裂纹,4-轨底掉块,5-灼伤,6-核伤,7-焊缝,8-其他）")
    private Integer damageType;

    @ApiModelProperty("伤损里程")
    private BigDecimal damageMileage;

    @ApiModelProperty("伤损程度(1-轻伤,2-轻伤有发展,3-重伤)")
    private Integer damageDegree;

    @ApiModelProperty("换轨计划")
    private String damagePlan;

    @ApiModelProperty("整改说明")
    private String reformRemark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;

}
