package org.jeecg.modules.maintenanceWork.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * <p>
 * 维修作业---道岔检查记录
 * </p>
 *
 * @author hkl
 * @since 2024-08-05
 */
@Getter
@Setter
@ApiModel(value = "WorkBatchDetailTurnoutInfo对象", description = "维修作业---道岔检查记录	")

public class WorkBatchDetailTurnoutInfoVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check）")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    private String deviceId;

    @ApiModelProperty("维修作业主表id")
    private String workId;

    @ApiModelProperty("维修作业单元表id")
    private String workDetailId;

    @ApiModelProperty("设备编号(道岔表设备编号W3301)")
    private String switchCode;

    @ApiModelProperty("设备号数(t_ek_records_master_turnout_info)")
    private String switchCodeNum;

    @ApiModelProperty("轨距水平尺编号")
    private String gaugeCode;

    @ApiModelProperty("检查项目类型（1：轨距；2：水平；3：支距；4：轮缘槽；5：滑床板；6：顶铁；7：接头螺栓；8：护轨螺栓；9:道岔）")
    private String type;

    @ApiModelProperty("值1")
    private String numOne;

    @ApiModelProperty("值2")
    private String numTwo;

    @ApiModelProperty("值3")
    private String numThree;

    @ApiModelProperty("值4")
    private String numFour;

    @ApiModelProperty("值5")
    private String numFive;

    @ApiModelProperty("值6")
    private String numSix;

    @ApiModelProperty("值7")
    private String numSeven;

    @ApiModelProperty("值8")
    private String numEight;

    @ApiModelProperty("值9")
    private String numNine;

    @ApiModelProperty("值10")
    private String numTen;

    @ApiModelProperty("值11")
    private String numTenOne;

    @ApiModelProperty("值12")
    private String numTenTwo;

    @ApiModelProperty("值13")
    private String numTenThree;

    @ApiModelProperty("值14")
    private String numTenFour;

    @ApiModelProperty("值15")
    private String numTenFive;

    @ApiModelProperty("值16")
    private String numTenSix;

    @ApiModelProperty("值17")
    private String numTenSeven;

    @ApiModelProperty("值18")
    private String numTenEight;

    @ApiModelProperty("值19")
    private String numTenNine;

    @ApiModelProperty("值20")
    private String numTwenty;

    @ApiModelProperty("值21")
    private String numTwentyOne;

    @ApiModelProperty("值22")
    private String numTwentyTwo;

    @ApiModelProperty("是否合格（1：合格；2：不合格）")
    private String qualified;

    @ApiModelProperty("不合格说明")
    private String noQualifiedRemark;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("整改说明")
    private String reformRemark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入道岔顺序")
    private Integer sort;


}
