package org.jeecg.modules.subwayNetwork.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 线路车站-轻轨线路
 * @Author: jeecg-boot
 * @Date: 2023-06-14
 * @Version: V1.0
 */
@Data
@TableName("t_sn_light_rail")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "t_sn_light_rail对象", description = "线路车站-轻轨线路")
public class LightRail implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;

    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    @ApiModelProperty(value = "线路名称")
    private String railLineName;

    @ApiModelProperty(value = "线路code")
    private String railLineCode;

    @ApiModelProperty(value = "状态")
    private Integer status;

    @ApiModelProperty(value = "上行线路里程")
    private BigDecimal upLineMileage;

    @ApiModelProperty(value = "下线路里程")
    private BigDecimal downLineMileage;

}
