package org.jeecg.modules.subwayNetwork.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@TableName("t_sn_section_station_map")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "t_sn_section_station_map对象", description = "线路车站-区间线路关联")
public class SectionStationMap {
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;

    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    @ApiModelProperty(value = "线路id")
    private String lightRailId;

    @ApiModelProperty(value = "线路名称")
    private String lightRailName;

    @ApiModelProperty(value = "区间id")
    private String sectionId;

    @ApiModelProperty(value = "区间名称")
    private String sectionName;

    @ApiModelProperty(value = "车站id")
    private String stationId;

    @ApiModelProperty(value = "车站名称")
    private String stationName;

    @ApiModelProperty("所属线别id")
    private String stationLineAliasId;

    @ApiModelProperty(value = "起始里程")
    private BigDecimal stationStartingMileage;

    @ApiModelProperty(value = "中心里程")
    private BigDecimal stationCenterMileage;

    @ApiModelProperty(value = "结束里程")
    private BigDecimal stationEndMileage;



}
