package org.jeecg.modules.subwayNetwork.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "线路VO")
public class LightRailQueryVO {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;

    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    @ApiModelProperty(value = "线路名称")
    private String railLineName;

    @ApiModelProperty(value = "线路code")
    private String railLineCode;

    @ApiModelProperty(value = "状态")
    private Integer status;

    @ApiModelProperty(value = "区间数量")
    private Integer subwaySectionNum;

    @ApiModelProperty(value = "车站数量")
    private Integer trainStationNum;

    @ApiModelProperty(value = "上行线路里程")
    private BigDecimal upLineMileage;

    @ApiModelProperty(value = "下线路里程")
    private BigDecimal downLineMileage;
}
