package org.jeecg.modules.subwayNetwork.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "地铁站VO")
public class TrainStationVO {

    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;

    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    @ApiModelProperty(value = "轻轨线路Id")
    private String lightRailId;

    @ApiModelProperty(value = "轻轨线路名称")
    private String lightRailName;

    @ApiModelProperty(value = "车站名")
    private String stationName;

    @ApiModelProperty(value = "线别id")
    private String lineAliasId;

    @ApiModelProperty(value = "线别Name")
    private String lineAliasName;

    @ApiModelProperty(value = "起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty(value = "中心里程")
    private BigDecimal centerMileage;

    @ApiModelProperty(value = "结束里程")
    private BigDecimal endMileage;

    @ApiModelProperty(value = "站台长度")
    private BigDecimal length;

    @ApiModelProperty(value = "顺序")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    private String remark;
}
